From Hammer Require Import Hammer.
(* start imports *)
Require Import List.
Require Import QArith.
Require Import Reals.
Import ListNotations.
Open Scope R_scope.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.

(* start prompt *)
(* 
  function_signature: "Definition generated_spec (impl: list R -> R -> bool) (numbers: list R) (threshold: R) : Prop :="
  docstring: Implementation impl must check if there are any two numbers closer to each other than given threshold in given list of numbers.
  test_cases:
    - input: [[1.0, 2.0, 3.0], 0.5]
      expected_output: False
    - input: [[1.0, 2.8, 3.0, 4.0, 5.0, 2.0], 0.3]
      expected_output: True
*)
(* end prompt *)

(* start problem_spec *)
Definition problem_spec (impl: list R -> R -> bool) (numbers: list R) (threshold: R) : Prop :=
  impl numbers threshold = true <-> exists a b : R,
    In a numbers /\ In b numbers /\ a <> b /\ Rabs (a - b) < threshold.
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: list R -> R -> bool) (numbers: list R) (threshold: R) : Prop :=
  impl numbers threshold = true <-> exists a b : R,
    In a numbers /\ In b numbers /\ a <> b /\ Rabs (a - b) < threshold.
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall numbers threshold, problem_spec impl numbers threshold) <->
               (forall numbers threshold, generated_spec impl numbers threshold).
Proof. hammer. Qed.
(* end equivalence *)
