From Hammer Require Import Hammer.
(* start imports *)
Require Import String.
Require Import Nat.
Import ListNotations.
Open Scope string_scope.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.

(* start prompt *)
(*
  function_signature: "Definition generated_spec (impl: string -> nat -> nat) (s: string) (n: nat) : Prop :="
  docstring: |
    In this task, you will be given a string that represents a number of apples and oranges
    that are distributed in a basket of fruit this basket contains
    apples, oranges, and mango fruits. Given the string that represents the total number of
    the oranges and apples and an integer that represent the total number of the fruits
    in the basket the implementation impl must return the number of the mango fruits in the basket.
  test_cases:
    - input: ["5 apples and 6 oranges", 19]
      expected_output: 8
    - input: ["0 apples and 1 oranges", 3]
      expected_output: 2
    - input: ["2 apples and 3 oranges", 100]
      expected_output: 95
    - input: ["100 apples and 1 oranges", 120]
      expected_output: 19
*)
(* end prompt *)

(* start context *)
Parameter parse_apples_oranges : string -> nat -> nat -> Prop.
(* end context *)

(* start problem_spec *)
Definition problem_spec (impl: string -> nat -> nat) (s: string) (n: nat) : Prop :=
  exists a o : nat,
    impl s n = n - (a + o) /\
    parse_apples_oranges s a o.
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: string -> nat -> nat) (s: string) (n: nat) : Prop :=
  exists a o : nat,
    impl s n = n - (a + o) /\
    parse_apples_oranges s a o.
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall s n, problem_spec impl s n) <->
               (forall s n, generated_spec impl s n).
Proof. hammer. Qed.
(* end equivalence *)
