From Hammer Require Import Hammer.
(* start imports *)
Require Import String.
Require Import Ascii.
Require Import Bool.
Open Scope string_scope.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.


(* start prompt *)
(*
  function_signature: "Definition generated_spec (impl: string -> bool) (s: string) : Prop :="
  docstring: |
    You are given a string s.
    Implementation impl must check if the string is happy or not.
    A string is happy if its length is at least 3 and every 3 consecutive letters are distinct
  test_cases:
    - input: "a"
      output: false
    - input: "aa"
      output: false
    - input: "abcd"
      output: true
    - input: "aabb"
      output: false
    - input: "adb"
      output: true
*)
(* end prompt *)

(* start problem_spec *)
Definition problem_spec (impl: string -> bool) (s: string) : Prop :=
  exists r, impl s = r /\
    match s with
    | EmptyString => r = false
    | String a s1 =>
      match s1 with
      | EmptyString => r = false
      | String b s2 =>
        match s2 with
        | EmptyString => r = false
        | String c s3 =>
          let distinct := (a <> b) /\ (a <> c) /\ (b <> c) in
          match s3 with
          | EmptyString =>
              (r = true <-> distinct)
          | _ =>
              (r = true <-> (distinct /\ impl (String b (String c s3)) = true))
          end
        end
      end
    end.
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: string -> bool) (s: string) : Prop :=
  exists r, impl s = r /\
    match s with
    | EmptyString => r = false
    | String a s1 =>
      match s1 with
      | EmptyString => r = false
      | String b s2 =>
        match s2 with
        | EmptyString => r = false
        | String c s3 =>
          let distinct := (a <> b) /\ (a <> c) /\ (b <> c) in
          match s3 with
          | EmptyString => (r = true <-> distinct)
          | _ => (r = true <-> (distinct /\ impl (String b (String c s3)) = true))
          end
        end
      end
    end.
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall s, problem_spec impl s) <->
               (forall s, generated_spec impl s).
Proof. hammer. Qed.
(* end equivalence *)
