From Hammer Require Import Hammer.
(* start imports *)
Require Import String.
Require Import Nat.
Open Scope string_scope.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.


(* start prompt *)
(*
  function_signature: "Definition generated_spec (impl: string -> bool) (s: string) : Prop :="
  docstring: |
    Implementation impl is a function that takes a string and returns True if the string
    length is a prime number or False otherwise
  test_cases:
    - input: "Hello"
      output: true
    - input: "abcdcba"
      output: true
    - input: "kittens"
      output: true
    - input: "orange"
      output: false
*)
(* end prompt *)

(* start problem_spec *)
Definition problem_spec (impl: string -> bool) (s: string) : Prop :=
  let is_prime (n : nat) : Prop :=
    2 <= n /\ ~ (exists k : nat, 2 <= k /\ k < n /\ Nat.modulo n k = 0)
  in
  exists r, impl s = r /\
            (r = true <-> is_prime (String.length s)).
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: string -> bool) (s: string) : Prop :=
  let is_prime (n : nat) : Prop :=
    2 <= n /\ ~ (exists k : nat, 2 <= k /\ k < n /\ Nat.modulo n k = 0)
  in
  exists r, impl s = r /\
            (r = true <-> is_prime (String.length s)).
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall s, problem_spec impl s) <->
               (forall s, generated_spec impl s).
Proof. hammer. Qed.
(* end equivalence *)
