From Hammer Require Import Hammer.
(* start imports *)
Require Import QArith.
Require Import List.
Require Import Bool.
Require Import Nat.
Import ListNotations.
Open Scope Q_scope.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.


(* start prompt *)
(*
  function_signature: "Definition generated_spec (impl: Q -> Q -> Q -> bool) (a b c: Q) : Prop :="
  docstring: |
    Implementation impl must obey the following:
    Create a function that takes 3 numbers.
    Returns true if one of the numbers is equal to the sum of the other two, and all numbers are integers.
    Returns false in any other cases.
  test_cases:
    - input: [5, 2, 7]
      expected_output: true
    - input: [3, 2, 2]
      expected_output: false
    - input: [3, -2, 1]
      expected_output: true
    - input: [3.6, -2.2, 2]
      expected_output: false
*)
(* end prompt *)

(* start problem_spec *)
Definition problem_spec (impl: Q -> Q -> Q -> bool) (a b c: Q) : Prop :=
    exists r, impl a b c = r /\
    (r = true <->
       (* < 3 is to check for the validity of indices, keep them here!! *)
       Qden a = 1%positive /\ Qden b = 1%positive /\ Qden c = 1%positive /\
       ((a + b = c) \/ (a + c = b) \/ (b + c = a))).
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: Q -> Q -> Q -> bool) (a b c: Q) : Prop :=
  exists r, impl a b c = r /\
    (r = true <->
       Qden a = 1%positive /\ Qden b = 1%positive /\ Qden c = 1%positive /\
       ((a + b = c) \/ (a + c = b) \/ (b + c = a))).
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall a b c, problem_spec impl a b c) <->
               (forall a b c, generated_spec impl a b c).
Proof. hammer. Qed.
(* end equivalence *)
