From Hammer Require Import Hammer.
(* start imports *)
Require Import String.
Require Import Ascii.
Require Import List.
Require Import Nat.
Import ListNotations.
Open Scope string_scope.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.


(* start prompt *)
(*
  function_signature: "Definition generated_spec (impl: string -> bool) (txt: string) : Prop :="
    docstring: |
        Implementation impl does the following:
        Create a function that returns True if the last character
        of a given string is an alphabetical character and is not
        a part of a word, and False otherwise.
        Note: "word" is a group of characters separated by space.
    test_cases:
    - input: "apple pie"
        expected_output: False
    - input: "apple pi e"
        expected_output: True
    - input: "apple pi e "
        expected_output: False
    - input: ""
        expected_output: False
*)
(* end prompt *)

(* start context *)
Parameter split_on_space : string -> list string.
Parameter get_char_opt : string -> nat -> option ascii.
Parameter char_is_alpha : ascii -> Prop.
(* end context *)

(* start problem_spec *)
Definition problem_spec (impl: string -> bool) (txt: string) : Prop :=
  exists r, impl txt = r /\
    let words := split_on_space txt in
    match words with
    | [] => r = false
    | _ =>
        let last_word := last words EmptyString in
        let len := String.length last_word in
        if Nat.eqb len 1
        then match get_char_opt last_word 0 with
             | Some ch => (r = true <-> char_is_alpha ch)
             | None => r = false
             end
        else r = false
    end.
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: string -> bool) (txt: string) : Prop :=
  exists r, impl txt = r /\
    let words := split_on_space txt in
    match words with
    | [] => r = false
    | _ =>
        let last_word := last words EmptyString in
        let len := String.length last_word in
        if Nat.eqb len 1
        then match get_char_opt last_word 0 with
             | Some ch => (r = true <-> char_is_alpha ch)
             | None => r = false
             end
        else r = false
    end.
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall txt, problem_spec impl txt) <->
               (forall txt, generated_spec impl txt).
Proof. hammer. Qed.
(* end equivalence *)
