From Hammer Require Import Hammer.
(* start imports *)
Require Import List.
Require Import Nat.
Require Import Bool.
Import ListNotations.
Open Scope nat_scope.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.


(* start prompt *)
(*
  function_signature: "Definition generated_spec (impl: nat -> bool) (a: nat) : Prop :="
  docstring: |
    Implementation impl must return true iff a < 100 and a is the product of three prime numbers.
  test_cases:
    - input: 30
      expected_output: true
*)
(* end prompt *)

(* start context *)
Parameter nat_prime : nat -> Prop.
(* end context *)

(* start problem_spec *)
Definition problem_spec (impl: nat -> bool) (a: nat) : Prop :=
  exists r, impl a = r /\
    (a < 100 -> (r = true <-> exists a' b c : nat,
                                  nat_prime a' /\ nat_prime b /\ nat_prime c /\
                                  a = a' * b * c)).
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: nat -> bool) (a: nat) : Prop :=
  exists r, impl a = r /\
    (a < 100 -> (r = true <-> exists a' b c : nat,
                                  nat_prime a' /\ nat_prime b /\ nat_prime c /\
                                  a = a' * b * c)).
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall a, problem_spec impl a) <->
               (forall a, generated_spec impl a).
Proof. hammer. Qed.
(* end equivalence *)
