From Hammer Require Import Hammer.
(* start imports *)
Require Import ZArith.
Open Scope Z_scope.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.


(* start prompt *)
(*
  function_signature: "Definition generated_spec (impl: Z -> Z -> bool) (x n: Z) : Prop :="
  docstring: |
        Implementation impl x n must return true if and only if x is equal to n
        raised to some natural-number exponent.
  test_cases:
    - input: (1, 4)
      expected_output: true
    - input: (2, 2)
      expected_output: true
    - input: (8, 2)
      expected_output: true
    - input: (3, 2)
      expected_output: false
    - input: (3, 1)
      expected_output: false
    - input: (5, 3)
      expected_output: false
*)
(* end prompt *)

(* start problem_spec *)
Definition problem_spec (impl: Z -> Z -> bool) (x n: Z) : Prop :=
  exists r, impl x n = r /\
            (r = true <-> exists k : nat, x = Z.pow n (Z.of_nat k)).
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: Z -> Z -> bool) (x n: Z) : Prop :=
  exists r, impl x n = r /\
            (r = true <-> exists k : nat, x = Z.pow n (Z.of_nat k)).
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall x n, problem_spec impl x n) <->
               (forall x n, generated_spec impl x n).
Proof. hammer. Qed.
(* end equivalence *)
