From Hammer Require Import Hammer.
(* start imports *)
Require Import ZArith.
Open Scope Z_scope.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.


(* start prompt *)
(*
  function_signature: "Definition generated_spec (impl: Z -> bool) (a: Z) : Prop :="
  docstring: |
    Implementation impl must return true iff there exists an integer n such that a = n^3.
  test_cases:
    - input: 1
      expected_output: true
    - input: 2
      expected_output: false
    - input: -1
      expected_output: true
    - input: 64
      expected_output: true
    - input: 0
      expected_output: true
    - input: 180
      expected_output: false
*)
(* end prompt *)

(* start problem_spec *)
Definition problem_spec (impl: Z -> bool) (a: Z) : Prop :=
  exists r, impl a = r /\
            (r = true <-> exists n : Z, a = n * n * n).
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: Z -> bool) (a: Z) : Prop :=
  exists r, impl a = r /\
            (r = true <-> exists n : Z, a = n * n * n).
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall a, problem_spec impl a) <->
               (forall a, generated_spec impl a).
Proof. hammer. Qed.
(* end equivalence *)
