From Hammer Require Import Hammer.
(* start imports *)
Require Import List.
Require Import ZArith.
Require Import Nat.
Import ListNotations.
Open Scope Z_scope.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.


(* start prompt *)
(*
  function_signature: "Definition generated_spec (impl: list Z -> Z) (lst: list Z) : Prop :="
  docstring: |
    Given a non-empty list of integers lst, implementation impl must add the even elements that are at odd indices.
  test_cases:
    - input: [4, 2, 6, 7]
      output: 2
*)
(* end prompt *)

(* start problem_spec *)
Definition problem_spec (impl: list Z -> Z) (lst: list Z) : Prop :=
  exists result, impl lst = result /\
    (length lst = 0%nat -> result = 0%Z) /\
    (length lst <> 0%nat ->
       if Nat.ltb 1 (length lst) then
         result = (if Z.even (nth 1 lst 0%Z) then nth 1 lst 0%Z else 0%Z) + impl (skipn 2 lst)
       else
         result = (if Z.even (nth 1 lst 0%Z) then nth 1 lst 0%Z else 0%Z)).
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: list Z -> Z) (lst: list Z) : Prop :=
  exists result, impl lst = result /\
    (length lst = 0%nat -> result = 0%Z) /\
    (length lst <> 0%nat ->
       if Nat.ltb 1 (length lst) then
         result = (if Z.even (nth 1 lst 0%Z) then nth 1 lst 0%Z else 0%Z) + impl (skipn 2 lst)
       else
         result = (if Z.even (nth 1 lst 0%Z) then nth 1 lst 0%Z else 0%Z)).
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall lst, problem_spec impl lst) <->
               (forall lst, generated_spec impl lst).
Proof. hammer. Qed.
(* end equivalence *)
