From Hammer Require Import Hammer.
(* start imports *)
Require Import ZArith.
Open Scope Z_scope.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.


(* start prompt *)
(*
  function_signature: "Definition generated_spec (impl: Z -> Z -> Z) (a b: Z) : Prop :="
  docstring: |
    Implementation impl must be a function that takes two integers and returns
    the product of their unit digits. Assume the input is always valid.
  test_cases:
    - input: 148, 412
      expected_output: 16
    - input: 19, 28
      expected_output: 72
    - input: 2020, 1851
      expected_output: 0
    - input: 14, -15
      expected_output: 20
*)
(* end prompt *)

(* start problem_spec *)
Definition problem_spec (impl: Z -> Z -> Z) (a b: Z) : Prop :=
  exists r, impl a b = r /\
    Z.abs r <= 81 /\
    Z.modulo r 10 = Z.modulo (a * b) 10 /\
    (Z.modulo b 10 <> 0 ->
       Z.modulo r (Z.modulo b 10) = 0 /\
       Z.modulo (Z.div r (Z.modulo b 10)) 100 = Z.modulo a 10) /\
    (Z.modulo a 10 <> 0 ->
       Z.modulo r (Z.modulo a 10) = 0 /\
       Z.modulo (Z.div r (Z.modulo a 10)) 100 = Z.modulo b 10) /\
    ((Z.modulo a 10 = 0) \/ (Z.modulo b 10 = 0) -> r = 0).
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: Z -> Z -> Z) (a b: Z) : Prop :=
  exists r, impl a b = r /\
    Z.abs r <= 81 /\
    Z.modulo r 10 = Z.modulo (a * b) 10 /\
    (Z.modulo b 10 <> 0 ->
       Z.modulo r (Z.modulo b 10) = 0 /\
       Z.modulo (Z.div r (Z.modulo b 10)) 100 = Z.modulo a 10) /\
    (Z.modulo a 10 <> 0 ->
       Z.modulo r (Z.modulo a 10) = 0 /\
       Z.modulo (Z.div r (Z.modulo a 10)) 100 = Z.modulo b 10) /\
    ((Z.modulo a 10 = 0) \/ (Z.modulo b 10 = 0) -> r = 0).
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall a b, problem_spec impl a b) <->
               (forall a b, generated_spec impl a b).
Proof. hammer. Qed.
(* end equivalence *)
