From Hammer Require Import Hammer.
(* start imports *)
Require Import String.
Require Import Ascii.
Require Import ZArith.
Require Import Nat.
Require Import Bool.

Open Scope string_scope.
Open Scope Z_scope.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.

(* start prompt *)
(*
  function_signature: "Definition generated_spec (impl: string -> Z) (s: string) : Prop :="
  docstring: |
    Implementation impl must return the number of uppercase vowels in even indices of s.
  test_cases:
    - input: "aBCdEf"
      expected_output: 1
    - input: "abcdefg"
      expected_output: 0
    - input: "dBBE"
      expected_output: 0
*)
(* end prompt *)

(* start context *)
Definition is_upper_vowel_bool (a: ascii) : bool :=
  let code := Ascii.nat_of_ascii a in
  Nat.eqb code 65 || Nat.eqb code 69 || Nat.eqb code 73 || Nat.eqb code 79 || Nat.eqb code 85.
(* end context *)

(* start problem_spec *)
Definition problem_spec (impl: string -> Z) (s: string) : Prop :=
  exists r, impl s = r /\
    match s with
    | EmptyString => r = 0%Z
    | String a s1 =>
      match s1 with
      | EmptyString =>
          if is_upper_vowel_bool a then r = 1%Z else r = 0%Z
      | String _ s2 =>
          if is_upper_vowel_bool a
          then r = 1%Z + impl s2
          else r = impl s2
      end
    end.
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: string -> Z) (s: string) : Prop :=
  exists r, impl s = r /\
    match s with
    | EmptyString => r = 0%Z
    | String a s1 =>
      match s1 with
      | EmptyString =>
          if is_upper_vowel_bool a then r = 1%Z else r = 0%Z
      | String _ s2 =>
          if is_upper_vowel_bool a
          then r = 1%Z + impl s2
          else r = impl s2
      end
    end.
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall s, problem_spec impl s) <->
               (forall s, generated_spec impl s).
Proof. hammer. Qed.
(* end equivalence *)
