From Hammer Require Import Hammer.
(* start imports *)
Require Import ZArith.
Require Import String.
Require Import Nat.
Open Scope Z_scope.
Open Scope string_scope.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.


(* start context *)
Parameter is_prime : nat -> Prop.
(* end context *)

(* start prompt *)
(*
function_signature: "Definition generated_spec (impl: (Z * Z) -> (Z * Z) -> string) (interval1 interval2: Z * Z) : Prop :="
docstring: |
    Implementation impl does the following:
    You are given two intervals,
    where each interval is a pair of integers. For example, interval = (start, end) = (1, 2).
    The given intervals are closed which means that the interval (start, end)
    includes both start and end.
    For each given interval, it is assumed that its start is less or equal its end.
    Your task is to determine whether the length of intersection of these two
    intervals is a prime number.
    Example, the intersection of the intervals (1, 3), (2, 4) is (2, 3)
    which its length is 1, which not a prime number.
    If the length of the intersection is a prime number, return "YES",
    otherwise, return "NO".
    If the two intervals don't intersect, return "NO".
test_cases:
  - input: [(1, 2), (2, 3)]
    expected_output: "NO"
  - input: [(-1, 1), (0, 4)]
    expected_output: "NO"
  - input: [(-3, -1), (-5, 5)]
    expected_output: "YES"
*)
(* end prompt *)

(* start problem_spec *)
Definition problem_spec (impl: (Z * Z) -> (Z * Z) -> string)
                       (interval1 interval2: Z * Z) : Prop :=
  let s1 := fst interval1 in
  let e1 := snd interval1 in
  let s2 := fst interval2 in
  let e2 := snd interval2 in
  (s1 <= e1) -> (s2 <= e2) ->
  let intersectionStart := Z.max s1 s2 in
  let intersectionEnd := Z.min e1 e2 in
  let hasIntersection := (intersectionStart <= intersectionEnd) in
  let len_nat := Z.to_nat (intersectionEnd - intersectionStart) in
  exists result, impl interval1 interval2 = result /\
    ( (result = "YES" <-> hasIntersection /\ is_prime len_nat) /\
      (result = "NO"  <-> ~ (hasIntersection /\ is_prime len_nat)) /\
      (result = "YES" \/ result = "NO") ).
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: (Z * Z) -> (Z * Z) -> string)
                          (interval1 interval2: Z * Z) : Prop :=
  let s1 := fst interval1 in
  let e1 := snd interval1 in
  let s2 := fst interval2 in
  let e2 := snd interval2 in
  (s1 <= e1) -> (s2 <= e2) ->
  let intersectionStart := Z.max s1 s2 in
  let intersectionEnd := Z.min e1 e2 in
  let hasIntersection := (intersectionStart <= intersectionEnd) in
  let len_nat := Z.to_nat (intersectionEnd - intersectionStart) in
  exists result, impl interval1 interval2 = result /\
    ( (result = "YES" <-> hasIntersection /\ is_prime len_nat) /\
      (result = "NO"  <-> ~ (hasIntersection /\ is_prime len_nat)) /\
      (result = "YES" \/ result = "NO") ).
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall i1 i2, problem_spec impl i1 i2) <->
               (forall i1 i2, generated_spec impl i1 i2).
Proof. hammer. Qed.
(* end equivalence *)
