From Hammer Require Import Hammer.
(* start imports *)
Require Import List.
Require Import Nat.
Import ListNotations.
Open Scope nat_scope.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.


(* start prompt *)
(*
  function_signature: "Definition generated_spec (impl: nat -> list nat) (n: nat) : Prop :="
  docstring: |
    Implementation impl must return a list of the first n + 1 numbers of the Tribonacci sequence.
    
    Everyone knows Fibonacci sequence, it was studied deeply by mathematicians in
    the last couple centuries. However, what people don't know is Tribonacci sequence.
    Tribonacci sequence is defined by the recurrence:
    tri(1) = 3
    tri(n) = 1 + n / 2, if n is even.
    tri(n) = tri(n - 1) + tri(n - 2) + tri(n + 1), if n is odd.
    For example:
    tri(2) = 1 + (2 / 2) = 2
    tri(4) = 3
    tri(3) = tri(2) + tri(1) + tri(4)
           = 2 + 3 + 3 = 8
    You are given a non-negative integer number n, you have to return a list of the
    first n + 1 numbers of the Tribonacci sequence.
  test_cases:
    - input: 3
      expected_output: [1, 3, 2, 8]
*)
(* end prompt *)

(* start problem_spec *)
Definition problem_spec (impl: nat -> list nat) (n: nat) : Prop :=
  exists res,
    impl n = res /\
    0 < length res /\
    length res = n /\
    let i := length res - 1 in
    (i = 0 -> nth 0 res 0 = 1) /\
    (i = 1 -> nth 1 res 0 = 3) /\
    (2 <= i /\ Nat.even i = true ->
        nth i res 0 = 1 + Nat.div i 2) /\
    (2 <= i /\ Nat.even i = false ->
        nth i res 0 =
          nth (i - 2) res 0 +
          nth (i - 1) res 0 +
          (1 + Nat.div (i + 1) 2)) /\
    (i <> 0 -> firstn i res = impl (i - 1)).
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: nat -> list nat) (n: nat) : Prop :=
  exists res,
    impl n = res /\
    0 < length res /\
    length res = n /\
    let i := length res - 1 in
    (i = 0 -> nth 0 res 0 = 1) /\
    (i = 1 -> nth 1 res 0 = 3) /\
    (2 <= i /\ Nat.even i = true ->
        nth i res 0 = 1 + Nat.div i 2) /\
    (2 <= i /\ Nat.even i = false ->
        nth i res 0 =
          nth (i - 2) res 0 +
          nth (i - 1) res 0 +
          (1 + Nat.div (i + 1) 2)) /\
    (i <> 0 -> firstn i res = impl (i - 1)).
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall n, problem_spec impl n) <->
               (forall n, generated_spec impl n).
Proof. hammer. Qed.
(* end equivalence *)
