From Hammer Require Import Hammer.
(* start imports *)
Require Import List.
Require Import QArith.
Require Import ZArith.
Import ListNotations.
Open Scope Q_scope.
Open Scope Z_scope.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.


(* start prompt *)
(*
  function_signature: "Definition generated_spec (impl: list Q -> Z) (lst: list Q) : Prop :="
  docstring: |
    Implementation impl implements the following:
    You are given a list of numbers.
    You need to return the sum of squared numbers in the given list,
    round each element in the list to the upper int(Ceiling) first.
  test_cases:
    - input: [1, 2, 3]
      expected_output: 14
    - input: [1, 4, 9]
      expected_output: 98
    - input: [1, 3, 5, 7]
      expected_output: 84
    - input: [1.4, 4.2, 0]
      expected_output: 29
    - input: [-2.4, 1, 1]
      expected_output: 6
*)
(* end prompt *)

(* start context *)
Parameter ceil_q : Q -> Z.
(* end context *)

(* start problem_spec *)
Definition problem_spec (impl: list Q -> Z) (lst: list Q) : Prop :=
  exists r, impl lst = r /\
    match lst with
    | [] => r = 0%Z
    | x :: xs => r = (let c := ceil_q x in c * c) + impl xs
    end.
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: list Q -> Z) (lst: list Q) : Prop :=
  exists r, impl lst = r /\
    match lst with
    | [] => r = 0%Z
    | x :: xs => r = (let c := ceil_q x in c * c) + impl xs
    end.
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall lst, problem_spec impl lst) <->
               (forall lst, generated_spec impl lst).
Proof. hammer. Qed.
(* end equivalence *)
