From Hammer Require Import Hammer.
(* start imports *)
Require Import Nat.
Require Import Bool.
Open Scope nat_scope.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.


(* start prompt *)
(*
  function_signature: "Definition generated_spec (impl: nat -> bool) (n: nat) : Prop :="
  docstring: |
    Implementation impl must evaluate whether the given number n can be written as the sum of exactly 4 positive even numbers
  test_cases:
    - input: 4
      expected_output: false
    - input: 6
      expected_output: false
    - input: 8
      expected_output: true
*)
(* end prompt *)

(* start problem_spec *)
Definition problem_spec (impl: nat -> bool) (n: nat) : Prop :=
  let even_pos (x : nat) : Prop := exists k : nat, 1 <= k /\ x = 2 * k in
  let sum_exists : Prop :=
    exists a b c d : nat,
        even_pos a /\ even_pos b /\ even_pos c /\ even_pos d /\
        a + b + c + d = n
  in
  exists r, impl n = r /\ (r = true <-> sum_exists).
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: nat -> bool) (n: nat) : Prop :=
  let even_pos (x : nat) : Prop := exists k : nat, 1 <= k /\ x = 2 * k in
  let sum_exists : Prop :=
    exists a b c d : nat,
        even_pos a /\ even_pos b /\ even_pos c /\ even_pos d /\
        a + b + c + d = n
  in
  exists r, impl n = r /\ (r = true <-> sum_exists).
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall n, problem_spec impl n) <->
               (forall n, generated_spec impl n).
Proof. hammer. Qed.
(* end equivalence *)
