From Hammer Require Import Hammer.
(* start imports *)
Require Import Nat.
Open Scope nat_scope.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.

(* start prompt *)
(*
  function_signature: "Definition generated_spec (impl: nat -> nat) (n: nat) : Prop :="
  docstring: |
    Implementation impl must return the Brazilian factorial:
    The Brazilian factorial is defined as:
    brazilian_factorial(n) = n! * (n-1)! * (n-2)! * ... * 1!
    where n > 0. Please write a function that computes the Brazilian factorial.
  test_cases:
    - input: 4
      expected_output: 288
*)
(* end prompt *)

(* start context *)
Parameter factorial : nat -> nat.
(* end context *)

(* start problem_spec *)
Definition problem_spec (impl: nat -> nat) (n: nat) : Prop :=
  let bf := fix bf k := match k with
    | 0 => 1
    | S m => bf m * factorial (S m)
    end in
  exists r, impl n = r /\ r = bf n.
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: nat -> nat) (n: nat) : Prop :=
  let bf := fix bf k := match k with
    | 0 => 1
    | S m => bf m * factorial (S m)
    end in
  exists r, impl n = r /\ r = bf n.
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall n, problem_spec impl n) <->
               (forall n, generated_spec impl n).
Proof. hammer. Qed.
(* end equivalence *)
