From Hammer Require Import Hammer.
(* start imports *)
Require Import Nat.
Open Scope nat_scope.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.


(* start prompt *)
(*
  function_signature: "Definition generated_spec (impl: nat -> nat -> nat -> nat) (n x y: nat) : Prop :="
  docstring: |
    Implementation impl is a simple program which should return the value of x if n is
    a prime number and should return the value of y otherwise.
  test_cases:
    - input: [7, 34, 12]
      expected_output: 34
    - input: [15, 8, 5]
      expected_output: 5
*)
(* end prompt *)

(* start context *)
Parameter is_prime : nat -> Prop.
(* end context *)

(* start problem_spec *)
Definition problem_spec (impl: nat -> nat -> nat -> nat) (n x y: nat) : Prop :=
  exists r, impl n x y = r /\
    (r = x <-> is_prime n) /\
    (r = y <-> (~ is_prime n \/ n <= 1)).
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: nat -> nat -> nat -> nat) (n x y: nat) : Prop :=
  exists r, impl n x y = r /\
    (r = x <-> is_prime n) /\
    (r = y <-> (~ is_prime n \/ n <= 1)).
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall n x y, problem_spec impl n x y) <->
               (forall n x y, generated_spec impl n x y).
Proof. hammer. Qed.
(* end equivalence *)
