From Hammer Require Import Hammer.
(* start imports *)
Require Import Nat.
Require Import Bool.
Open Scope nat_scope.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.


(* start prompt *)
(*
  function_signature: "Definition generated_spec (impl: nat -> nat -> nat -> bool) (a b c: nat) : Prop :="
  docstring: |
    Implementation impl does the following:
    Given the lengths of the three sides of a triangle. Return True if the three
    sides form a right-angled triangle, False otherwise.
    A right-angled triangle is a triangle in which one angle is right angle or
    90 degree.
    Note: Generated specification is not allowed to use inequality, only comparison operators.
  test_cases:
    - input: [3, 4, 5]
      expected_output: true
    - input: [1, 2, 3]
      expected_output: false
*)
(* end prompt *)

(* start problem_spec *)
Definition problem_spec (impl: nat -> nat -> nat -> bool) (a b c: nat) : Prop :=
  exists r, impl a b c = r /\
    (r = true <->
       0 < a /\ 0 < b /\ 0 < c /\
       ((a * a + b * b = c * c) \/
        (a * a + c * c = b * b) \/
        (b * b + c * c = a * a))).
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: nat -> nat -> nat -> bool) (a b c: nat) : Prop :=
  exists r, impl a b c = r /\
    (r = true <->
       0 < a /\ 0 < b /\ 0 < c /\
       ((a * a + b * b = c * c) \/
        (a * a + c * c = b * b) \/
        (b * b + c * c = a * a))).
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall a b c, problem_spec impl a b c) <->
               (forall a b c, generated_spec impl a b c).
Proof. hammer. Qed.
(* end equivalence *)
