From Hammer Require Import Hammer.
(* start imports *)
Require Import List.
Require Import ZArith.
Import ListNotations.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.

(* start prompt *)
(* 
  function_signature: "Definition generated_spec (impl: list Z -> bool) (x: list Z) : Prop :="
  docstring: |
        Takes a list of integers as an input.
        Implementation impl returns True if there are two distinct elements in the list that
        sum to zero, and False otherwise.
  test_cases:
    - input: [1, 3, 5, 0]
        expected_output: False
    - input: [1, 3, -2, 1]
        expected_output: False
    - input: [1]
        expected_output: False
    - input: [2, 4, -5, 3, 5, 7]
        expected_output: True
*)
(* end prompt *)

(* start problem_spec *)
Definition problem_spec (impl: list Z -> bool) (numbers: list Z) : Prop :=
  impl numbers = true <-> exists a b : Z,
    In a numbers /\ In b numbers /\
    a <> b /\ 
    (a + b = 0)%Z.
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: list Z -> bool) (x: list Z) : Prop :=
  impl x = true <-> exists a b : Z,
    In a x /\ In b x /\ a <> b /\ (a + b = 0)%Z.
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall x, problem_spec impl x) <->
               (forall x, generated_spec impl x).
Proof. hammer. Qed.
(* end equivalence *)
