From Hammer Require Import Hammer.
(* start imports *)
Require Import List.
Require Import Arith.
Require Import Nat.
Import ListNotations.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.

(* start prompt *)
(*
  function_signature: "Definition generated_spec (impl: nat -> nat -> nat) (n p: nat) : Prop :="
  docstring: |
    Implementation impl must return 2^n modulo p.
  test_cases:
    - input: [3, 5]
      expected_output: 3
    - input: [1101, 101]
      expected_output: 2
    - input: [0, 101]
      expected_output: 0
    - input: [100, 101]
      expected_output: 1
*)
(* end prompt *)

(* start problem_spec *)
Definition problem_spec (impl: nat -> nat -> nat) (n p: nat) : Prop :=
  exists r, impl n p = r /\
            0 < p /\
            r < p /\
            exists k, p * k + r = Nat.pow 2 n.
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: nat -> nat -> nat) (n p: nat) : Prop :=
  exists r, impl n p = r /\
            0 < p /\
            r < p /\
            exists k, p * k + r = Nat.pow 2 n.
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall n p, problem_spec impl n p) <->
               (forall n p, generated_spec impl n p).
Proof. hammer. Qed.
(* end equivalence *)
