From Hammer Require Import Hammer.
(* start imports *)
Require Import ZArith.
Open Scope Z_scope.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.


(* start prompt *)
(*
  function_signature: "Definition generated_spec (impl: Z -> Z -> Z) (x y: Z) : Prop :="
  docstring: |
    Implementation impl must return x + y.
  test_cases:
    - input: [2, 3]
      expected_output: 5
    - input: [5, 7]
      expected_output: 12
*)
(* end prompt *)

(* start problem_spec *)
Definition problem_spec (impl: Z -> Z -> Z) (x y: Z) : Prop :=
  exists r, impl x y = r /\ r = x + y.
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: Z -> Z -> Z) (x y: Z) : Prop :=
  exists r, impl x y = r /\ r = x + y.
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall x y, problem_spec impl x y) <->
               (forall x y, generated_spec impl x y).
Proof. hammer. Qed.
(* end equivalence *)
