From Hammer Require Import Hammer.
(* start imports *)
Require Import List.
Import ListNotations.
Open Scope Z_scope.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.

(* start prompt *)
(*
  function_signature: "Definition generated_spec (impl: list nat -> bool) (numbers: list nat) : Prop :="
  docstring: |
    Return True if list elements are monotonically increasing or decreasing.
  test_cases:
    - input: [1, 2, 4, 20]
      expected_output: true
    - input: [1, 20, 4, 10]
      expected_output: false
    - input: [5, 2, 1, 0]
      expected_output: true
*)
(* end prompt *)

(* start problem_spec *)
Definition problem_spec (impl: list nat -> bool) (numbers: list nat) : Prop :=
  let non_ordered : Prop :=
      exists i j : nat,
        (i + 1 < length numbers) /\
        (j + 1 < length numbers) /\
        lt (nth i numbers 0) (nth (i + 1) numbers 0) /\
        lt (nth (j + 1) numbers 0) (nth j numbers 0)
  in
  exists result, impl numbers = result /\
    (1 < length numbers -> (result = true <-> ~ non_ordered)).
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: list nat -> bool) (numbers: list nat) : Prop :=
  let non_ordered : Prop :=
      exists i j : nat,
        (i + 1 < length numbers) /\
        (j + 1 < length numbers) /\
        lt (nth i numbers 0) (nth (i + 1) numbers 0) /\
        lt (nth (j + 1) numbers 0) (nth j numbers 0)
  in
  exists result, impl numbers = result /\
    (1 < length numbers -> (result = true <-> ~ non_ordered)).
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall numbers, problem_spec impl numbers) <->
               (forall numbers, generated_spec impl numbers).
Proof. hammer. Qed.
(* end equivalence *)
