From Hammer Require Import Hammer.
(* start imports *)
Require Import String.
Require Import Ascii.
Require Import Nat.
Require Import List.
Import ListNotations.
Open Scope string_scope.
(* end imports *)

Set Hammer ATPLimit 4.
Set Hammer ReconstrLimit 2.


(* start prompt *)
(*
  function_signature: "Definition generated_spec (impl: string -> nat) (s: string) : Prop :="
  docstring: |
    Implementation impl must return the sum of ASCII codes of uppercase characters in the string.
  test_cases:
    - input: ""
      expected_output: 0
    - input: "abAB"
      expected_output: 131
    - input: "helloE"
      expected_output: 69
*)
(* end prompt *)

(* start problem_spec *)
Definition problem_spec (impl: string -> nat) (s: string) : Prop :=
  exists r, impl s = r /\
    match s with
    | EmptyString => r = 0
    | String a s' =>
        let code := Ascii.nat_of_ascii a in
        (if andb (Nat.leb 65 code) (Nat.leb code 90)
         then r = code + impl s'
         else r = impl s')
    end.
(* end problem_spec *)

(* start generated_spec *)
Definition generated_spec (impl: string -> nat) (s: string) : Prop :=
  exists r, impl s = r /\
    match s with
    | EmptyString => r = 0
    | String a s' =>
        let code := Ascii.nat_of_ascii a in
        (if andb (Nat.leb 65 code) (Nat.leb code 90)
         then r = code + impl s'
         else r = impl s')
    end.
(* end generated_spec *)

(* start equivalence *)
Theorem spec_equiv :
  forall impl, (forall s, problem_spec impl s) <->
               (forall s, generated_spec impl s).
Proof. hammer. Qed.
(* end equivalence *)
