from dataclasses import dataclass
from typing_extensions import Literal
from typing import Any


@dataclass(frozen=True)
class SolverReply:
    verdict: Literal["success", "failure", "unknown"]
    counterexample: str | None = None
    error_message: str | None = None
    other_details: dict[str, Any] | str | None = None
    judge_score: None | int = None
