import traceback
from common.task import SqlTask
from common.verdict import SolverReply
from evaluators.solvers.sql.sql_testing.environment import Environment


def solve_sql(*, task: SqlTask, timeout_ms: int) -> SolverReply:
    llm_answer = task.llm_solution
    if llm_answer == "" or llm_answer is None:
        return SolverReply(verdict="unknown", error_message="Empty LLM answer")

    try:
        # TAKEN FROM POLYGON
        default_k = {
            "filter": 4,
            "project": 4,
            "union": 4,
            "inner join": 4,
            "left join": 4,
            "right join": 4,
            "full join": 4,
            "product": 4,
            "order by": 2,
        }

        env = Environment(
            task.schema,
            task.constraints,
            bound=task.bound,
            default_k=default_k,
            time_budget=int(timeout_ms / 1000.0),
        )

        eq, cex, _checking_time, total_time, ret = env.check(task.answer, llm_answer)

        if eq:
            return SolverReply(
                verdict="success", other_details={"time": total_time, "ret": ret}
            )
        elif eq is None:
            return SolverReply(
                verdict="unknown", other_details={"time": total_time, "ret": ret}
            )
        elif eq is False:
            return SolverReply(
                verdict="failure",
                counterexample=cex,
                other_details={"time": total_time, "ret": ret},
            )
        raise ValueError("Unhandled case")

    except Exception:
        error_message = traceback.format_exc()
        return SolverReply(
            verdict="unknown", error_message=f"Error during solving: {error_message}"
        )
