import random
import logging
from .base import BaseScheme
from collections import Counter


ContextPrompts = {
    'keyword': 'We are extracting every occurrence of country names, preserving duplicates and maintaining their original order in the paragraph: ',
    'yelp': 'We are counting the number of positive reviews from the review list: '
}
Task_Specific_Example = {
    'yelp': """Input: [REVIEW_1] A menu that satisfies everyone's cravings! Clean, trendy, and delicious! I definitely recommend going early (before 9 am) as the wait tends to get longer after 9 am! But honestly, it is soooo worth the wait. You will leave there feeling so incredible satisfied! [REVIEW_2] I am a long term frequent customer of this establishment. I just went in to order take out (3 apps) and was told they're too busy to do it. Really? The place is maybe half full at best. Does your dick reach your ass? Yes? Go fuck yourself! I'm a frequent customer AND great tipper. Glad that Kanella just opened. NEVER going back to dmitris!

Let's think step by step. 

Output: 
[REVIEW_1] A menu that satisfies everyone's cravings! Clean, trendy, and delicious! I definitely recommend going early (before 9 am) as the wait tends to get longer after 9 am! But honestly, it is soooo worth the wait. You will leave there feeling so incredible satisfied! 
this is a positive review
[REVIEW_2] I am a long term frequent customer of this establishment. I just went in to order take out (3 apps) and was told they're too busy to do it. Really? The place is maybe half full at best. Does your dick reach your ass? Yes? Go fuck yourself! I'm a frequent customer AND great tipper. Glad that Kanella just opened. NEVER going back to dmitris!
this is a not a positive review

Final answer: the number of positive review is 1

Input: [REVIEW_1] The pasta was amazing and the service was excellent! [REVIEW_2] The food was great but the service was terrible. [REVIEW_3] I love this place and will definitely come back!

Let's think step by step. 

Output:
[REVIEW_1] The pasta was amazing and the service was excellent! 
this is a positive review
[REVIEW_2] The food was great but the service was terrible. 
this is a not a positive review
[REVIEW_3] I love this place and will definitely come back!
this is a a positive review

Final answer: the number of positive review is 2

Input: {query}

Let's think step by step. 

Output:

""",
    'keyword': """Input: Alexandra boarded the first flight of her grand journey, starting from Canada. With a globe-trotting itinerary in hand, she was filled with excitement. Her first stop was Mexico, where she marveled at the Mayan ruins. From there, she explored the rainforests of Brazil and danced the tango in Argentina. 

Let's think step by step. 

Output: 
1. Analyze sentence: Alexandra boarded the first flight of her grand journey, starting from Canada.
This Sentence has country names: Canada
2. Analyze sentence: With a globe-trotting itinerary in hand, she was filled with excitement. 
This Sentence has country names: 
3. Analyze sentence: Her first stop was Mexico, where she marveled at the Mayan ruins. 
This Sentence has country names: Mexico
4. Analyze sentence: From there, she explored the rainforests of Brazil and danced the tango in Argentina.
This Sentence has country names: Brazil, Argentina
5.Combine results:
Canada, Mexico, Brazil, Argentina

Final Answer: [Canada, Mexico, Brazil, Argentina]

Input: The adventure led him to the peaks of Peru where he trekked to see the mysteries of Machu Picchu. He then headed to Chile to gaze at the vastness of the Atacama Desert. A quick detour to Uruguay and Paraguay allowed him to experience the vibrancy of the local cultures before returning back to Canada through Peru, Brazil and Mexico. 

Let's think step by step. 

Output: 
1. Analyze sentence: The adventure led him to the peaks of Peru where he trekked to see the mysteries of Machu Picchu. 
This Sentence has country names: Peru
2. Analyze sentence: He then headed to Chile to gaze at the vastness of the Atacama Desert. 
This Sentence has country names: Chile
3. Analyze sentence: A quick detour to Uruguay and Paraguay allowed him to experience the vibrancy of the local cultures before returning back to Canada through Peru, Brazil and Mexico. 
This Sentence has country names: Uruguay, Paraguay, Canada, Peru, Brazil, Mexico
4.Combine results:
Peru, Chile, Uruguay, Paraguay, Canada, Peru, Brazil, Mexico

Final Answer: [Peru, Chile, Uruguay, Paraguay, Canada, Peru, Brazil, Mexico]

Input: Journeying westward, she admired the art in Italy and sipped coffee in France. The music of Spain and the history of Greece deepened her love for Europe. The Nordic beauty of Norway, Sweden, Finland, and Denmark took her breath away. She danced in Ireland, explored castles in Scotland, and marveled at the architecture in Germany and Russia. Italy, Norway, Sweden and Germany will always stay her favourite destinations to visit.

Let's think step by step. 

Output: 

1. Analyze sentence: Journeying westward, she admired the art in Italy and sipped coffee in France. This Sentence has country names: Italy, France
2. Analyze sentence: The music of Spain and the history of Greece deepened her love for Europe. 
This Sentence has country names: Spain, Greece
3. Analyze sentence: The Nordic beauty of Norway, Sweden, Finland, and Denmark took her breath away.
This Sentence has country names:  Norway, Sweden, Finland, Denmark 
4. Analyze sentence: She danced in Ireland, explored castles in Scotland, and marveled at the architecture in Germany and Russia. 
Ireland, Scotland, Germany, Russia
5. Analyze sentence: Italy, Norway, Sweden, Germany
6.Combine results:
Italy, France, Spain, Greece, Norway, Sweden, Finland, Denmark, Ireland, Scotland, Germany, Russia, Italy, Norway, Sweden, Germany

Final Answer: [Italy, France, Spain, Greece, Norway, Sweden, Finland, Denmark, Ireland, Scotland, Germany, Russia, Italy, Norway, Sweden, Germany]

Input: {query}

Let's think step by step. 

Output:
"""



}


class ZeroCoT(BaseScheme):
    
    def prep_const_prompt(self):
        self.cot_prompt = "Let's think step by step"

    def prep_task_spcefics(self):
        self.context = ContextPrompts[self.args.task]

    def extract_answer(self, output):
        # print(output)
        if self.args.task == 'keyword':
            final_output = self.llm_answer(f"format the answer {output} in a one-line list (square brackets) without quotes. example: [Country, Country, Country, ..., Country]")
        elif self.args.task == 'yelp':
            final_output = self.llm_answer(f"Based on the {output}, output the number of positive reviews. Output only an integer.")
        else:
            final_output = self.llm_answer("extract the numerical of the answer:"+output)

        return final_output

    def solve_query(self, query):
        output = self.llm_answer(self.context + query + self.cot_prompt)
        output = self.extract_answer(output)

        # logging.info(f'>>>>>>>>>>>> final result: {output} <<<<<<<<<<<<<')
        # input()
        return output

class ChainofThought(ZeroCoT):
    
    def prep_task_spcefics(self):
        self.context = ContextPrompts[self.args.task]
        self.cot_example = Task_Specific_Example.get(self.args.task)

    def solve_query_once(self, query):
        output = self.llm_answer(self.context + self.cot_example.format(query=query))
        output = self.extract_answer(output)

        # logging.info(f'>>>>>>>>>>>> final result: {output} <<<<<<<<<<<<<')
        # print(self.ground_truth)
        # input()
        return output

    def solve_query(self, query):
        return self.solve_query_once(query)

class SelfConsistentCoT(ChainofThought):

    def solve_query(self, query):
        output_list = []
        for __ in range(5):
            output = self.solve_query_once(query)
            output_list.append(output)

        counter = Counter(output_list)
        most_common_count = counter.most_common(1)[0][1]

        # Find all candidates with the most common count
        candidates = [key for key, count in counter.items() if count == most_common_count]

        # Randomly select one if tied
        return random.choice(candidates)