import random
import torch

from Hash.KWiseHash import KWiseHash

INF = 1e10

class JL:
    def __init__(self, pi, sample_size=0):
        self.tau = INF
        self.pi = pi
        self.sample_size = sample_size
        self.stored_items = None

    def __len__(self):
        return self.stored_items.shape[0] * self.stored_items.shape[1]

    def __mul__(self, other):
        return torch.matmul(self.stored_items.T, other.stored_items)

    def __str__(self):
        return str(self.stored_items)

    def hash(self, data_set):
        self.stored_items = torch.matmul(self.pi, data_set)
