# -*- coding: utf-8 -*-
"""
Created on Fri Aug  9 09:53:17 2024

@author: kernel
"""
import matplotlib.pyplot as plt
import numpy as np
import pandas as pd
np.random.seed(10)
plt.rcParams['figure.dpi'] = 600



def compute_f(x0, x1, x2, x3, x4):
    return 0.1 * x0 * x1 + 0.1 * np.sin(x2 * x3) + np.sin(x4) 
    # return 0.1 * x0 * x1 + 0.5 * np.sin(x2 * x3) + 1 * np.sin(x4 )

# 初始化 x0, x1, x2, x3, x4
noise = 0.05
x = np.random.uniform(0, 0.2, 5)

# 存储生成的 f 值
f_values = []

# 进行N次实验
N = 200 # 可以根据需要调整实验次数
epsilon =np.random.normal(0, noise, N)

for i in range(N):
    f = compute_f(x[0], x[1], x[2], x[3], x[4]) + epsilon[i]
    f_values.append(f)
    # 更新变量
    x = np.roll(x, -1)
    x[-1] = f  # 将最后一个元素设置为新计算的 f

print("Generated f values:", f_values)
df = pd.DataFrame(f_values, columns=['f_values'])






plt.figure(figsize=(6, 4))
plt.plot(df[:], color='dodgerblue', linewidth=2,linestyle='-')
ax = plt.gca()
ax.spines['top'].set_visible(False)
ax.spines['right'].set_visible(False)
plt.title(f'Noise = {noise}', fontsize=12)
plt.show()


# 保存到 CSV 文件
df.to_csv(f'model_13_{noise}.csv', index=False)