# -*- coding: utf-8 -*-
"""
Created on Fri Aug  9 09:53:17 2024

@author: kernel
"""

import numpy as np
import pandas as pd
np.random.seed(10)



def compute_f(x0, x1, x2, x3, x4):
    return 0.1 * x0 * x1 + 0.1 * np.sin(x2 * x3) + np.sin(x4 )
    # return 0.1 * x0 * x1 + 0.5 * np.sin(x2 * x3) + 1 * np.sin(x4 )

# 初始化 x0, x1, x2, x3, x4
x = np.random.uniform(0, 0.2, 5)

# 存储生成的 f 值
f_values = []

# 进行N次实验
N = 200 # 可以根据需要调整实验次数
for i in range(N):
    f = compute_f(x[0], x[1], x[2], x[3], x[4])
    f_values.append(f)
    # 更新变量
    x = np.roll(x, -1)
    x[-1] = f  # 将最后一个元素设置为新计算的 f

print("Generated f values:", f_values)
df = pd.DataFrame(f_values, columns=['f_values'])

# 保存到 CSV 文件
df.to_csv('model_2.csv', index=False)