# -*- coding: utf-8 -*-
"""
Created on Sat Aug 17 00:02:53 2024

@author: pt
"""
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
plt.rcParams['figure.dpi'] = 600
FNN_loss = np.load('FNN_loss.npy')
XNet_loss = np.load('XNet_loss.npy')
LSTM_loss = np.load('LSTM_loss.npy')
XLSTM_loss = np.load('XLSTM_loss.npy')


start_epoch = 0
end_epoch = 200

plt.figure(figsize=(10, 6))
plt.plot(FNN_loss[start_epoch:end_epoch + 1], label='FNN Loss')
plt.plot(XNet_loss[start_epoch:end_epoch + 1], label='XNet Loss')
plt.plot(LSTM_loss[start_epoch:end_epoch + 1], label='LSTM Loss')
plt.plot(XLSTM_loss[start_epoch:end_epoch + 1], label='XLSTM Loss')

# 添加图例
plt.legend()

# 添加标题和坐标轴标签
plt.title(f'Training Loss Comparison from Epoch {start_epoch} to {end_epoch}')
plt.xlabel('Epochs')
plt.ylabel('Loss')

# 计算绘图用的Epoch数和刻度
epoch_range = end_epoch - start_epoch
num_ticks = 7  # 希望在x轴上显示的刻度数量
tick_spacing = epoch_range // (num_ticks - 1)

# 调整x轴刻度，使其反映实际的Epoch数
plt.xticks(
    ticks=np.linspace(0, epoch_range, num_ticks),  # 创建均匀的刻度
    labels=np.arange(start_epoch, end_epoch + 1, tick_spacing)  # 将刻度标签设置为从start_epoch到end_epoch
)

# 显示图形
plt.show()