import datetime
import os
import re
import shutil
import subprocess
import pypinyin
from utils import *

def hanzi_to_pinyin(hanzi):
    pinyin_list = pypinyin.pinyin(hanzi, style=pypinyin.Style.NORMAL)
    pinyin_str = ''.join([py[0] for py in pinyin_list])

    return pinyin_str

def extract_text_between_brackets(text):
    pattern = r"](.*?)\["  
    match = re.search(pattern, text)
    if match:
        extracted_text = match.group(1)
        return extracted_text
    else:
        pattern = r"】(.*?)\["
        match = re.search(pattern, text)
        if match:
            extracted_text = match.group(1)
            return extracted_text
        else:
            return None


def extract_ex_numbers(text):
    print(text)
    pattern = ""
    if("EP" in text):
        pattern = r"EP(\d+)\."
    elif("E" in text):
        pattern = r"E(\d+)\."  

    matches = re.findall(pattern, text)
    if matches:
        return matches
    else:
        return None


def convert_mkv_to_wav(video_file, output_file):
    subprocess.call(['ffmpeg', '-i', video_file, '-vn', '-acodec', 'pcm_s16le', '-ar', '16000', '-ac', '1', output_file])

def is_english_string(text):
    pattern = r'^[A-Za-z.,!?\'"\s]+$'
    return re.match(pattern, text) is not None

def normalizing_tv_name(root_folder):
    start = datetime.datetime.now()
    for folder_name in os.listdir(root_folder):
        folder_path = os.path.join(root_folder, folder_name)
        file_paths = get_file_paths(folder_path)

        source_name = os.path.basename(folder_path)

        tv_name = "" 
        if(is_english_string(source_name)):
            tv_name = source_name
        else:
            tv_name = hanzi_to_pinyin(source_name)


        for file_path in file_paths:
            episodes_num = "" 
            episodes_num = extract_ex_numbers(file_path)

            new_file_name = ""       
            if file_path.endswith(".mkv") and len(episodes_num) == 1:
                new_file_name = os.path.join(folder_path, tv_name + "-" + episodes_num[0] + ".mkv")
                os.rename(file_path, new_file_name)
            elif(file_path.endswith(".mp4") and len(episodes_num) == 1):
                new_file_name = os.path.join(folder_path, tv_name + "-" + episodes_num[0] + ".mp4")
                os.rename(file_path, new_file_name)
            else:
                continue

            file_path = new_file_name
            filename = str(os.path.basename(file_path).split(".")[0])
            convert_mkv_to_wav(file_path, folder_path + "\\" + filename + ".wav")

    end = datetime.datetime.now()