import datetime
import os
import soundfile
from ppasr.infer_utils.vad_predictor import VADPredictor
from utils import *

def vad_split_function(tv_name, input_wav, input_mkv, output_dir):
    vad_predictor = VADPredictor()
    wav, sr = soundfile.read(input_wav, dtype='float32')
    speech_timestamps = vad_predictor.get_speech_timestamps(wav, sr)
    input_video = input_mkv
    os.makedirs(output_dir, exist_ok=True)

    previous_time = 0 
    start_sample = 0   
    count = 0         
    valid_time = 0    
    mute_interval = 4  

    for index, item in enumerate(speech_timestamps):
        start_time = item["start"]
        end_time = item["end"]


        temp_time = start_time/sr - previous_time   

        if temp_time > mute_interval and previous_time != 0:
            end_sample = previous_time * sr
            
            start_time_str_temp = str(datetime.timedelta(seconds=start_sample/sr))
            end_time_str_temp = str(datetime.timedelta(seconds=end_sample/sr))


            if(valid_time/(end_sample-start_sample)>0.3 and valid_time/sr>15):
                start_time_temp = int(start_sample)
                end_time_temp = int(end_sample)

                speech_segment = wav[start_time_temp:end_time_temp]
                output_path = os.path.join(output_dir,f'{tv_name}_{index}_{start_sample/sr}_{end_sample/sr}.wav')

                soundfile.write(output_path, speech_segment, sr) 

            start_sample = start_time
            count = 0
            valid_time = 0
        else:
            count += 1
            valid_time += (end_time - start_time)

        previous_time = end_time/sr                 

def vad_split(root_folder):
    start = datetime.datetime.now()
    for folder_name in os.listdir(root_folder):
        folder_path = os.path.join(root_folder, folder_name)
        file_paths = get_file_paths(folder_path)
        for file_path in file_paths:
            print(file_path)
            if(file_path.endswith(".wav")):
                input_wav = file_path  
                input_mkv = str(file_path.split(".")[0]) + ".mkv"
                tv_name = os.path.basename(file_path).split(".")[0]
                output_wav = folder_path + "\\one-step\\" + str(tv_name.split("-")[-1])
                vad_split_function(tv_name, input_wav, input_mkv, output_wav)

    end = datetime.datetime.now()