import subprocess
from ray.tune import CLIReporter
from ray.tune.result import TIMESTEPS_TOTAL, TRAINING_ITERATION, TIME_TOTAL_S


def get_reporter(parameter_columns=None,
                 metric_columns=None,
                 max_report_frequency=30,
                 max_progress_rows=40,
                 sort_by_metric=True):

  default_metric = {TRAINING_ITERATION: "iter", TIMESTEPS_TOTAL: "ts"}
  metric_columns.update(default_metric)

  reporter = CLIReporter(
      parameter_columns=parameter_columns,
      metric_columns=metric_columns,
      max_report_frequency=max_report_frequency,
      max_progress_rows=max_progress_rows,
      sort_by_metric=sort_by_metric)
  return reporter


def get_git_commit_hash():
  try:
    # Get the current Git commit hash
    commit_hash = subprocess.check_output(['git', 'rev-parse',
                                           'HEAD']).decode('utf-8').strip()
    return 'git_' + commit_hash[:5] + '_'
  except Exception as e:
    print(f"Error obtaining Git commit hash: {e}")
    return None
