#!/bin/bash
# pkill -f "python test_vmoc.py*"
# Define an array of Atari game tasks
declare -a tasks=("HalfCheetah-v4" "Swimmer-v4" "HumanoidStandup-v4" "Reacher-v4" "Walker2d-v4" "Hopper-v4" "InvertedPendulum-v4" "InvertedDoublePendulum-v4" "Ant-v4" "Humanoid-v4")

# Maximum number of concurrent jobs
max_jobs=24
num_gpus=8
gpu_index=0
num_iter=10

# Create logs directory if it does not exist
mkdir -p logs

# Function to limit the number of concurrent jobs
function job_limit {
    while true; do
        num_jobs=$(jobs -p | wc -l)
        # Ensure num_jobs is a valid integer
        if [ -z "$num_jobs" ]; then
            num_jobs=0
        fi
        if [ "$num_jobs" -lt "$max_jobs" ]; then
            break
        fi
        sleep 1  # Wait a bit before checking again
    done
}

# Loop over each task
for i in $(seq 1 $num_iter); do
    # Run each task 10 times with different parameters
    for task in "${tasks[@]}"; do
        job_limit  # Call the function to limit jobs
        echo "Running $task iteration $i with default parameters on GPU $gpu_index"
        CUDA_VISIBLE_DEVICES=$gpu_index python test_vmoc.py --rand True --env $task --device cuda &
        # Update GPU index in a round-robin fashion
        gpu_index=$(( (gpu_index + 1) % num_gpus ))
    done
done

# Wait for all background jobs to complete
wait
