from mdp_helper_files.exp_track_helper import *
import Experiments as eXP

import argparse
import os
import subprocess

submit_job_script_template = "\
#!/usr/bin/env bash\n\
#SBATCH -p dgx2\n\
#SBATCH -c 2\n\
#SBATCH --gres=gpu:1\n\
# The above settings request 1 GPU & 4 CPU cores in the DGX2 queue\n\
#SBATCH -J $JobName\n\
#SBATCH -o $OutputFile\n\
# Job name, file to write job output to. \n\
cd $ProjectDirectory\n\
WHOAMI=$(whoami)\n\
echo \"* Hi! from compute server $(hostname)!\"\n\
echo \"* The current directory is ${PWD}.\"\n\
echo \"* Compute server\'s CPU model and number of logical CPUs:\"\n\
lscpu | grep \'Model name\'\n\
lscpu | grep \'CPU(s)\'\n\
\n\
python ExperimentRunner.py --exp_ids $ExperimentId\n\
echo \"Job Completed\"\n\
"

parser = argparse.ArgumentParser()
parser.add_argument("--submit_jobs", help="set if we want to submit the jobs to the cluster",action= "store_true")
parser.add_argument("--exp_ids", help="Name of the project", type=str,nargs="+", default=["none"])
parser.add_argument("--append", help="string to append at the end of the command", default="")
parser.add_argument("--remove", help="string to remove from the command", nargs="+", default=[""])
parser.add_argument("--replace", help="string to remove from the command", nargs=2, default=["", ""])
parser.add_argument("--replace1", help="string to remove from the command", nargs=2, default=["", ""])
parser.add_argument("--replace2", help="string to remove from the command", nargs=2, default=["", ""])
parser.add_argument("--replace3", help="string to remove from the command", nargs=2, default=["", ""])

args = parser.parse_args()
assert args.exp_ids[0] != "none", "Script name must be passed, at least one"


if args.submit_jobs:
    if not os.path.exists('submit_job_logs'):
        os.makedirs('submit_job_logs')

    # make a submit files for each of the of the experiments
    for exp_id in args.exp_ids:
        modifiers = {"$ProjectDirectory":os.getcwd(),
                     "$ExperimentId": exp_id,
                    "$JobName": exp_id,
                    "$OutputFile": f"{os.getcwd()}/submit_job_logs/{exp_id}.out" }
        submit_file_text = submit_job_script_template
        for var,value in modifiers.items():
            submit_file_text = submit_file_text.replace(var,value)

        submit_file_name = f'submit_job_logs/{exp_id}.sh'
        file_object = open(submit_file_name, 'w')
        file_object.write(submit_file_text)
        file_object.close()
        print(f"{submit_file_name} Created")

    # Run each submit files
    for exp_id in args.exp_ids:
        submit_file_name = f'submit_job_logs/{exp_id}.sh'
        result = subprocess.run(["sbatch" , submit_file_name], stdout=subprocess.PIPE)
        print(result.stdout)

else:
    print("Appending:{} Removing:{}".format(args.append, args.remove))
    for exp_id in args.exp_ids:
        original_command = eXP.ExpPool.get_by_id(exp_id).command
        modified_command = original_command + " " + args.append
        for to_remove_string in args.remove:
            modified_command = modified_command.replace(to_remove_string, "")

        for replace_option in [args.replace, args.replace1, args.replace2, args.replace3]:
            to_replace, replace_with = replace_option
            print("replacing {} with {}".format(to_replace,replace_with))
            modified_command = modified_command.replace(to_replace,replace_with)

        modified_command =  ' '.join(modified_command.split())

        print("Running Experiment Id: ", exp_id)
        print("Original Command: ", original_command)
        print("Running Command: ", modified_command)
        os.system(modified_command)
        print("Execution complete moving to next command.")
    

