## Fully First-Order Constrained Bilevel Optimization
This repo includes the implementation of NeurIPS 2024 submission #6047 "Fully First-Order Methods for Constrained Bilevel Optimization".

### Dependencies
- CvxpyLayer: https://github.com/cvxgrp/cvxpylayers
- Pytorch
- Numpy

### Linear inequality constraints
- Non-fully first order method (implemented using CvxpyLayer):
` python3 main.py --solver=cvxpylayer --seed=0 --ydim=20 --n-constraints=5`

- Fully first-order method:
`python3 main.py --solver=ffo --seed=0 --ydim=20 --n-constraints=5`

### Analysis visualization
To analyze the results, you can use the `analysis.py` script. Please simply run `python analysis.py` and find the visualization in the folder `figures`.


### Bilinear inequality constraints
For bilinear inequality constraints, the LICQ assumption may not hold, but we still impelment the algorithm to test its performance for bilinear inequality constraints.
The bilinear example is implemented in `main_bilinear.py`. You can also run the non-fully first order and fully first-order methods for the bilinear case using the following commands:

- Non-fully first order method (implemented using CvxpyLayer):
` python3 main_bilinear.py --solver=cvxpylayer --seed=0 --ydim=20 --n-constraints=5`

- Fully first-order method:
`python3 main_bilinear.py --solver=ffo --seed=0 --ydim=20 --n-constraints=5`


You can change the optimizer inside `main.py`
