import cv2
import math
import numpy as np
from PIL import Image
import copy
import matplotlib.pyplot as plt
import torch
def MatrixToImage(data):
    new_im = Image.fromarray(data.astype(np.uint8))
    return new_im

# 加载一个灰度图像
source_img = cv2.imread('img.png')
new_img = copy.deepcopy(source_img)
source_img=torch.from_numpy(source_img)
source_img=source_img.permute(2,0,1).unsqueeze(0)

print(source_img.shape)
# 获取高、宽
rows=400
cols = 400
learning_rate = 0.01

def V(imgs):
    img_size = imgs.shape
    change_img = np.zeros(img_size)
    for k in range(3):
        for i in range(img_size[0]):
            for j in range(img_size[1]):
                offset_x = int(50.0 * math.cos(2 * math.pi * i / 180))
                offset_y = int(50.0 * math.sin(2 * math.pi * j / 180))
                if j + offset_x < img_size[0] and i + offset_y < img_size[1]:
                    change_img[i, j, k] = imgs[(i + offset_y) % img_size[0], (j + offset_x) % img_size[1], k]
                else:
                    change_img[i, j, k] = 255
    return change_img


for i in range(100):
    new_img = new_img + learning_rate*V(new_img)+0.02*new_img*np.random.randn(400,400,3)
#delta = (new_img - source_img).flatten()

cv2.imwrite("new_img2.jpg", new_img)

for i in range(100):
    new_img = new_img - learning_rate*V(new_img)+0.02*new_img*np.random.randn(400,400,3)

cv2.imwrite("new_img3.jpg", new_img)
