# Quick‑start: simulate, visualize, and infer a Hawkes process (no features)
import numpy as np
from openhawkes.simulation   import ExpHawkes
from openhawkes.visualization import plot_intensity_and_jumps_same_yscale
from openhawkes.inference    import fit_hawkes
 
# make numpy printouts nice
np.set_printoptions(precision=2, suppress=True)

# 1) Define Hawkes parameters
mu    = [0.1, 0.15, 0.2]
alpha = [[0.5, 0.0, 0.0],
         [0.0, 0.0, 0.5],
         [0.1, 0.2, 0.0]]
beta  = [1.0, 2.0, 1.0]   # per‑dimension decay

nb_types = len(mu)

# 2) Instantiate & simulate up to max_time=1000
proc   = ExpHawkes(mu, alpha, beta, seed=0)
events = proc.simulate(max_time=1000)
print(f"Generated {len(events.times)} events across {nb_types} dimensions")

# 3) Visualize intensities and jumps
plot_intensity_and_jumps_same_yscale(proc, steps=2000)

# 4) Infer parameters via MLE (no features)
model = fit_hawkes(
    nb_types=nb_types,
    times=events.times,
    types=events.types,
    nb_batches=10,
    beta_unique=False
)

print("\n--- Recovered parameters ---")
print("μ    =", model.mu.detach().cpu().numpy())
print("α    =", model.alpha.detach().cpu().numpy())
print("β    =", model.beta.detach().cpu().numpy())
