"""
OpenHawkes: Multivariate Hawkes processes with exponential kernels.

Modules
-------
simulation
    Ogata thinning simulation of constant‐ or dimension‐specific kernels.

visualization
    Plot intensities and jump times on aligned subplots.

models
    PyTorch log‐likelihood modules for constant‐α and feature‐dependent Hawkes.

inference
    High‐level `fit_hawkes` wrapper to select model and run MLE.

utils
    Helpers for batching, masking, regularisation, and synthetic feature generation.


Usage
-----
>>> from openhawkes.simulation import ExpHawkes
>>> proc = ExpHawkes(mu, alpha, beta)
>>> events = proc.simulate(max_time=100)
>>> from openhawkes.inference import fit_hawkes
>>> model = fit_hawkes(nb_types, events.times, events.types, nb_batches=10)

See README.md for full examples.
"""
