import numpy as np
from openhawkes.simulation import ExpHawkes

def test_simulate_minimal():
    mu = [0.1, 0.2]
    alpha = np.eye(2) * 0.3
    beta = 1.0
    proc = ExpHawkes(mu, alpha, beta, seed=0)
    ev = proc.simulate(max_events=50)
    assert len(ev.times) == 50
    assert all(0 <= ty < 2 for ty in ev.types)
