import os
import subprocess

txt_root = 'txt'

# para_hidden_sizes = [256, 512, 1024]
# para_n_layers = [3, 4, 5]

para_hidden_sizes = [64]
para_n_layers = [3, 4, 5]

# cudas = [2, 3, 1, 5, 6, 7]
cudas = [2] * 6 + [1] * 12

# cudas = [1]

settings_loss = [
    # 'ablation_0.05',
    # 'ablation_0.01',
    # 'ablation_0.005',
    # 'ablation_0.001',
    # 'ablation_0.0005',
    # 'ablation_0.0001',

    # 'naive',
    
    'jensen_0.05',
    'jensen_0.01',
    'jensen_0.005',
    'jensen_0.001',
    'jensen_0.0005',
    'jensen_0.0001',

    
    'momentum_1.0',
    'momentum_0.5',
    'momentum_0.1',
    'momentum_0.05',
    'momentum_0.01',
    'momentum_0.005',

    'implicit_energy_0.05',
    'implicit_energy_0.01',
    'implicit_energy_0.005',
    'implicit_energy_0.001',
    'implicit_energy_0.0005',
    'implicit_energy_0.0001',
]


assert len(cudas) == len(settings_loss)


processes = []

os.makedirs(txt_root, exist_ok=True)
for cuda, loss in zip(cudas, settings_loss):
    for hidden_size in para_hidden_sizes:
        for n_layers in para_n_layers:
            with open(os.path.join(txt_root, f'log_{loss}_{str(hidden_size)}_{str(n_layers)}.txt'), 'w') as log_file:
                process = subprocess.Popen(
                    ['python', 'train.py', str(hidden_size), str(n_layers), str(cuda), loss],
                    stdout=log_file, stderr=log_file
                )
                processes.append(process)

for process in processes:
    process.wait()

print("All tasks completed.")
