# Gridded Transformer Neural Processes
A framework for implementing and reproducing the ICLR paper "Gridded Transformer Neural Processes" in Python.

## Setting up the conda environment.
```bash
conda create -n tnp python=3.12
conda activate tnp
pip install -r requirements.txt
pip install -e .
```

## Downloading ERA5 data.
### Combining station observations and gridded reanalysis data.
```bash
python experiments/era5_download.py --start_year 2009 --end_year 2019 --num_processes 4
```
### Combining multiple sources.
```bash
python experiments/mm_era5_download.py --start_year 2009 --end_year 2019 --num_processes 4
```

### Synthetic GP regression data.
```bash
python experiments/generate_gp_data.py --gen_name train --num_processes 4 --config experiments/configs/generators/pregenerate-gp.yml

python experiments/generate_gp_data.py --gen_name train-large-lengthscale --num_processes 4 --config experiments/configs/generators/pregenerate-gp.yml

python experiments/generate_gp_data.py --gen_name test --num_processes 4 --config experiments/configs/generators/pregenerate-gp.yml

python experiments/generate_gp_data.py --gen_name test-large-lengthscale --num_processes 4 --config experiments/configs/generators/pregenerate-gp.yml
```

## Training models.

### Synthetic GP regression experiments.
Here we train the Swin-TNP using the pseudo-token grid encoder (PT-GE).
```bash
python experiments/lightning_train.py --config experiments/configs/models/gp/swintnp.yml experiments/configs/models/grid_encoders/pt-ge.yml experiments/configs/grid_decoders/mhca-gd.yml --generator_config experiments/configs/generators/gp.yml

python experiments/lightning_train.py --config experiments/configs/models/gp/swintnp.yml experiments/configs/models/grid_encoders/pt-ge.yml experiments/configs/grid_decoders/mhca-gd.yml --generator_config experiments/configs/generators/gp.yml
```

### Combining station observations and gridded reanalysis data.
Here we train the Swin-TNP using the pseudo-token grid encoder (PT-GE).
```bash
python experiments/slurm_lightning_train.py --config experiments/configs/models/ootg-swintnp.yml experiments/configs/models/grid_encoders/ootg-pt-ge.yml experiments/configs/grid_decoders/mhca-gd.yml --generator_config experiments/configs/generators/ootg-era5.yml experiments/configs/data/era5-nc-files.yml
```

### Combining multiple sources.
Here we train the Swin-TNP using the multi pseudo-token grid encoder (PT-GE).
```bash
python experiments/slurm_lightning_train.py --config experiments/configs/models/mm-swintnp.yml experiments/configs/models/grid_encoders/mm-pt-ge.yml experiments/configs/grid_decoders/mhca-gd.yml --generator_config experiments/configs/generators/mm-era5.yml experiments/configs/data/mm-era5-nc-files.yml
```