# DUSDi: Disentangled Unsupervised Skill Discovery for Efficient Hierarchical Reinforcement Learning
This codebase was adapted from [URLB](https://github.com/rll-research/url_benchmark).



## Requirements
We assume you have access to a GPU that can run CUDA 10.2 and CUDNN 8. Then, the simplest way to install all required dependencies is to create an anaconda environment by running
```sh
conda env create -f conda_env.yml
```
After the instalation ends you can activate your environment with
```sh
conda activate urlb
```


## Additional Installation Requirements
- gymnasium==0.28.1
- functorch==0.2.1
- numpy==1.23 (required by igibson)


## Instructions
### Test skills
```sh
python test_skills.py snapshot_ts=TS snapshot_name=NAME domain=particle render=true
```

### Pre-training
To run pre-training use the `pretrain.py` script
```sh
python pretrain.py agent=multi_diayn domain=particle
```
The snapshots will be stored under the following directory:
```sh
./models/<obs_type>/<domain>/<agent>/
```

### Downstream Hierarhical Learning
Once you have pre-trained your method, you can use the saved snapshots to learn downstream task. 
```sh
python train.py n_env=4 domain=particle ds_task=DS_TASK
```

### Monitoring
Logs are stored in the `exp_local` folder. To launch tensorboard run:
```sh
tensorboard --logdir exp_local
```
The console output is also available in a form:
```
| train | F: 6000 | S: 3000 | E: 6 | L: 1000 | R: 5.5177 | FPS: 96.7586 | T: 0:00:42
```
a training entry decodes as
```
F  : total number of environment frames
S  : total number of agent steps
E  : total number of episodes
R  : episode return
FPS: training throughput (frames per second)
T  : total training time
```

