#!/bin/bash

export PYTHONPATH=~/regcache/src

VERSION=clip_evaluate_original
DIR=/home/user/regcache/result
RESULT_FILE=${DIR}/${VERSION}_result.out
mkdir -p ${DIR} ${DIR}/log ${CACHE_DIR}
LOGFILE=${DIR}/log/${VERSION}.log

BIT=None
W_QUANT=None
A_QUANT=None


CUDA_VISIBLE_DEVICES=7 python -m open_clip_train.main_search \
    --imagenet-val /home/user/data/ILSVRC2012/train_sample_50_per_class \
    --model ViT-B-16-quickgelu \
    --pretrained openai \
    --seed 42 \
    --wbits ${BIT} \
    --abits ${BIT} \
    --w-quant-type ${W_QUANT} \
    --a-quant-type ${A_QUANT} \
    --num-classes 0 \
    --model-name clip \
    --batch-size 64 \
    --bit 3 \
    --baseline awq \
    \
    --prefix-add \
    --cache-option KV_Cache \
    --max-global-prefix-rank 20 \
    --target-block 4 \
    --target-layer ffn_fc2 \
    # --max-prefix-number 15 \
    # --token-delete-block "[7]" \
    # --max-token-delete-number 10 \


