#!/bin/bash

export PYTHONPATH=~/regcache/src

VERSION=siglip_evaluate_noisyquant
DIR=/home/user/regcache/result
RESULT_FILE=${DIR}/${VERSION}_result.out
mkdir -p ${DIR} ${DIR}/log ${CACHE_DIR}
LOGFILE=${DIR}/log/${VERSION}.log

BIT=8
W_QUANT=per_tensor
A_QUANT=per_tensor

CUDA_VISIBLE_DEVICES=2 python -m open_clip_train.main_search \
    --imagenet-val /data/ILSVRC2012/val \
    --model ViT-B-16-SigLIP \
    --pretrained webli \
    --seed 42 \
    --wbits ${BIT} \
    --abits ${BIT} \
    --w-quant-type ${W_QUANT} \
    --a-quant-type ${A_QUANT} \
    --num-classes 0 \
    --model-name siglip \
    --batch-size 64 \
    --bit ${BIT} \
    --baseline noisyquant \
    --calib /home/user/data/ILSVRC2012/1024calib_train \
    --calib-num 256 \
    --with-noisy-quant \
    --percentile \
    --search-noisy \
    --search-mean \
    \
    --eval-only \
    --prefix-add \
    --cache-option KV_Cache \
    --prefix-add-block "[4,5,6,7,8,9,10,11]" \
    --prefix-number 2 \
    --global-prefix-rank 11 \
    --target-block 4 \
    --target-layer ffn_fc2 \
    --token-delete \
    --token-delete-block "[5]" \
    --token-delete-number 3 \

    # > ${RESULT_FILE} 2>&1
    # --token-delete-previous-layer 0 \
    # --token-delete-method value \
    # --head-index-for-score 2 \
