#!/bin/bash

export PYTHONPATH=~/regcache/src

VERSION=siglip_prefix_search_noisyquant
DIR=/home/user/regcache/result
RESULT_FILE=${DIR}/${VERSION}_result.out
mkdir -p ${DIR} ${DIR}/log ${CACHE_DIR}
LOGFILE=${DIR}/log/${VERSION}.log

BIT=8
W_QUANT=per_tensor
A_QUANT=per_tensor

CUDA_VISIBLE_DEVICES=5 python -m open_clip_train.main_search_noisyquant \
    --imagenet-val /home/user/data/ILSVRC2012/train_sample_50_per_class \
    --model ViT-B-16-SigLIP \
    --pretrained webli \
    --seed 42 \
    --wbits ${BIT} \
    --abits ${BIT} \
    --w-quant-type ${W_QUANT} \
    --a-quant-type ${A_QUANT} \
    --num-classes 0 \
    --model-name siglip \
    --batch-size 64 \
    --bit ${BIT} \
    --baseline noisyquant \
    --calib /home/user/data/ILSVRC2012/1024calib_train \
    --calib-num 256 \
    --with-noisy-quant \
    --percentile \
    --search-noisy \
    --search-mean \
    \
    --prefix-add \
    --cache-option KV_Cache \
    --prefix-add-block "[4,5,6,7,8,9,10,11]" \
    --max-prefix-number 10 \
    --global-prefix-rank 5 \
    --target-block 4 \
    --target-layer ffn_fc2 \
    --prefix-num-search-mode \
