#!/bin/bash

export PYTHONPATH=~/regcache/src

VERSION=siglip_evaluate_ptq4vit
DIR=/home/user/regcache/result
RESULT_FILE=${DIR}/${VERSION}_result.out
mkdir -p ${DIR} ${DIR}/log ${CACHE_DIR}
LOGFILE=${DIR}/log/${VERSION}.log

BIT=6
W_QUANT=per_tensor
A_QUANT=per_tensor

CUDA_VISIBLE_DEVICES=5 python -m open_clip_train.main_search \
    --imagenet-val /data/ILSVRC2012/val \
    --model ViT-B-16-SigLIP \
    --pretrained webli \
    --seed 42 \
    --wbits ${BIT} \
    --abits ${BIT} \
    --w-quant-type ${W_QUANT} \
    --a-quant-type ${A_QUANT} \
    --num-classes 0 \
    --model-name siglip \
    --batch-size 64 \
    --bit ${BIT} \
    --baseline ptq4vit \
    \
    --eval-only \
    --prefix-add \
    --cache-option KV_Cache \
    --prefix-add-block "[4,5,6,7,8,9,10,11]" \
    --prefix-number 1 \
    --global-prefix-rank 20 \
    --target-block 4 \
    --target-layer ffn_fc2 \
    --token-delete \
    --token-delete-block "[5]" \
    --token-delete-number 0 \
