#!/bin/bash

export PYTHONPATH=~/regcache/src

VERSION=clip_evaluate_original
DIR=/home/user/regcache/result
RESULT_FILE=${DIR}/${VERSION}_result.out
mkdir -p ${DIR} ${DIR}/log ${CACHE_DIR}
LOGFILE=${DIR}/log/${VERSION}.log

BIT=8
W_QUANT=per_tensor
A_QUANT=per_tensor

CUDA_VISIBLE_DEVICES=0 python -m open_clip_train.main_search \
    --ms-coco /data/COCO/coco_data/val2017 \
    --ms-coco-annot /data/COCO/coco_data/annotations/captions_val2017.json \
    --model ViT-B-16-quickgelu \
    --pretrained openai \
    --seed 42 \
    --wbits ${BIT} \
    --abits ${BIT} \
    --w-quant-type ${W_QUANT} \
    --a-quant-type ${A_QUANT} \
    --num-classes 0 \
    --model-name clip \
    --batch-size 64 \
    --bit ${BIT} \
    --baseline repqvit \
    --calib-coco /home/user/data/coco/1024calib_train \
    --calib-num 32 \
    \
    --eval-only \
    --prefix-add \
    --cache-option KV_Cache \
    --prefix-add-block "[4,5,6,7,8,9,10,11]" \
    --prefix-number 1 \
    --global-prefix-rank 17 \
    --target-block 4 \
    --target-layer ffn_fc2 \
    --token-delete \
    --token-delete-block "[7]" \
    --token-delete-number 2 \

