#!/bin/bash

export PYTHONPATH=~/regcache/src

VERSION=clip_evaluate_original
DIR=/home/user/regcache/result
RESULT_FILE=${DIR}/${VERSION}_result.out
mkdir -p ${DIR} ${DIR}/log ${CACHE_DIR}
LOGFILE=${DIR}/log/${VERSION}.log

BIT=None
W_QUANT=None
A_QUANT=None

CUDA_VISIBLE_DEVICES=5 python -m open_clip_train.main_search_general_config \
    --imagenet-val /home/user/data/ILSVRC2012/train_sample_50_per_class \
    --model ViT-B-16 \
    --pretrained laion2b_s34b_b88k \
    --seed 42 \
    --wbits ${BIT} \
    --abits ${BIT} \
    --w-quant-type ${W_QUANT} \
    --a-quant-type ${A_QUANT} \
    --num-classes 0 \
    --model-name openclip \
    --batch-size 64 \
    --bit 8 \
    --baseline awq \
    \
    --prefix-add \
    --cache-option KV_Cache \
    --prefix-add-block "[4,5,6,7,8,9,10,11]" \
    --max-prefix-number 15 \
    --token-delete-block "[6]" \
    --max-token-delete-number 10 \
    --global-prefix-rank 4 \
    --target-block 4 \
    --target-layer ffn_fc2 \



